//
//  MCArrayFlattenFormatter.h
//  MCFoundation
//
//  Created by Alykhan Jetha on 20/08/2006.
//  Copyright 1999-2006 Marketcircle Inc. All rights reserved.
//  
//  Takes an array as an argument. If there are keypaths provided, 
//  calls those and put them into a string. Returns a string.
//
//  Formats (in quotes for illustration purposes):
/*
  record separator ! field separator ! keypaths (comma separated)
 
 
  'CR! '
  'CR! !firstname,lastname,contactID'
  'CR! !?'
  'CR!TAB!$'

  The ? is used to denote: try name, if does not respond try displayString, if does not respond try stringValue, string, description.
  The $ is used to denote: if we get a number, apply the default currency formatter
 
  CR is short for newline
  TAB is short for tab
  Other values are taken literally
 
  You cannot use !,? and $ as a separator value
*/


#import <Foundation/Foundation.h>


@interface MCArrayFlattenFormatter : NSFormatter {
	NSString *fieldSeparator;
	NSString *recordSeparator;
	NSArray *keypaths;
	BOOL tryDynamicKeypath;
	BOOL applyDefaultCurrencySubFormat;
}

- (NSString *)fieldSeparator;
- (void)setFieldSeparator:(NSString *)aFieldSeparator;

- (NSString *)recordSeparator;
- (void)setRecordSeparator:(NSString *)aRecordSeparator;

- (NSArray *)keypaths;
- (void)setKeypaths:(NSArray *)aKeypaths;

- (BOOL)tryDynamicKeypath;
- (void)setTryDynamicKeypath:(BOOL)flag;

- (BOOL)applyDefaultCurrencySubFormat;
- (void)setApplyDefaultCurrencySubFormat:(BOOL)flag;


- (void)setFormat:(NSString *)aFormat;

@end
